/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.lockmgr;

import com.ibm.hsc.common.exceptions.FspLockException;
import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.HscResourceId;
import com.ibm.hsc.common.util.PIParseResponse;
import com.ibm.hsc.fsp.cmdhelpers.FspCmdHelper;
import com.ibm.hsc.fsp.cmdhelpers.FspHmcInfoData;
import com.ibm.hsc.fsp.cmdhelpers.FspHmcInformation;
import com.ibm.hsc.fsp.cmdhelpers.FspLockRecord;
import com.ibm.hsc.fsp.lockmgr.FspLockRequest;
import com.ibm.hsc.fsp.lockmgr.FspReqRecord;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class FspLockMgr {
    private OmCecMgr mCecMgr;
    private Hashtable mLockRecords = new Hashtable();
    private boolean mActive = false;
    private boolean mSupportMultiHmc = false;
    private static final long mHmcToolType = 1213023008L;

    public FspLockMgr(OmCecMgr omCecMgr) {
        this.mCecMgr = omCecMgr;
    }

    FspCmdHelper getCmdHelper() {
        return this.mCecMgr.getCmdHelper();
    }

    public void setSupportMultiHMC(boolean bl) {
        this.mSupportMultiHmc = bl;
    }

    public boolean getSupportMultiHMC() {
        return this.mSupportMultiHmc;
    }

    public void reinitialize(byte[] byArray, int n) {
        System.out.println("reinitialize lock mgr " + n);
        if (n != 0 && n != 8) {
            return;
        }
        try {
            if (this.mActive) {
                this.disconnect();
            }
            this.mActive = true;
            System.out.println("set mActive to true");
            this.unlockAll();
            this.persistentLockRecover();
            UnsignedInt8[] unsignedInt8Array = this.mCecMgr.getCmdHelper().getInterfaceCapabilities();
            this.mSupportMultiHmc = (unsignedInt8Array[4].shortValue() & 2) != 0;
        }
        catch (Throwable throwable) {
            this.mSupportMultiHmc = true;
            throwable.printStackTrace();
        }
    }

    public void disconnect() {
        System.out.println("close lock manager for " + this.mCecMgr.getCecName());
        this.printLockTable();
        this.mLockRecords.clear();
        this.mActive = false;
    }

    private void persistentLockRecover() {
    }

    public UnsignedInt32 lock(Vector vector, int n, int n2) throws PIHscServerException {
        if (!this.mActive) {
            System.out.println("do fsp lock and lock manager is not active");
            throw new PIHscServerException("026E", new String[]{this.mCecMgr.getCecName()}, null);
        }
        FspLockRequest fspLockRequest = new FspLockRequest(this, vector);
        do {
            try {
                UnsignedInt32 unsignedInt32 = fspLockRequest.lock();
                System.out.println("fsp lock success " + unsignedInt32);
                this.mLockRecords.put(unsignedInt32, fspLockRequest);
                return unsignedInt32;
            }
            catch (PIHscCmdMgrException pIHscCmdMgrException) {
                pIHscCmdMgrException.printStackTrace();
                System.out.println("fsp lock failed. retry time left " + --n2);
                int n3 = pIHscCmdMgrException.getStatus();
                if (n2 != 0) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(n * 1000);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    continue;
                }
                if (n3 == 29) {
                    System.out.println("fsp lock table full");
                    throw new FspLockException("025E", null, 2, null, null);
                }
                if (n3 == 31) {
                    System.out.println("fsp lock conflict");
                    byte[] byArray = pIHscCmdMgrException.getMessagePayload();
                    Hashtable hashtable = null;
                    if (byArray != null) {
                        try {
                            hashtable = PIParseResponse.parseByCmd("LOCK_RET", byArray);
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                    if (hashtable != null) {
                        System.out.println("conflict hmc id " + hashtable.get("HMC_ID"));
                        System.out.println("conflict req id " + hashtable.get("REQ_ID"));
                        throw new FspLockException("025A", new String[]{(String)hashtable.get("HMC_ID"), hashtable.get("REQ_ID").toString()}, 0, (UnsignedInt32)hashtable.get("REQ_ID"), (String)hashtable.get("HMC_ID"));
                    }
                    throw new FspLockException("025F", null, 1, null, null);
                }
                System.out.println("unexpected lock error " + n3);
                throw new FspLockException("0260", new String[]{"" + n3}, 3, null, null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new PIHscServerException("0261", throwable);
            }
        } while (n2 != 0 && this.mActive);
        if (!this.mActive) {
            System.out.println("lock mgr is not active, stop retry");
            throw new PIHscServerException("0261", null);
        }
        return null;
    }

    public UnsignedInt32 lock(FspReqRecord fspReqRecord, int n, int n2) throws PIHscServerException {
        Vector<FspReqRecord> vector = new Vector<FspReqRecord>();
        vector.addElement(fspReqRecord);
        return this.lock(vector, n, n2);
    }

    public void unlock(UnsignedInt32 unsignedInt32) throws PIHscServerException {
        if (!this.mActive) {
            System.out.println("unlock " + unsignedInt32 + " and lock manager is not active");
            throw new PIHscServerException("026E", new String[]{this.mCecMgr.getCecName()}, null);
        }
        FspLockRequest fspLockRequest = (FspLockRequest)this.mLockRecords.get(unsignedInt32);
        if (fspLockRequest == null) {
            System.out.println("cannot find req id " + unsignedInt32 + " in id table " + this.mLockRecords);
            return;
        }
        fspLockRequest.unlock(null);
        this.mLockRecords.remove(unsignedInt32);
        System.out.println("fsp unlock success " + unsignedInt32);
    }

    FspLockRequest getLockRequestByFspId(UnsignedInt32 unsignedInt32) {
        Enumeration enumeration = this.mLockRecords.keys();
        while (enumeration.hasMoreElements()) {
            UnsignedInt32 unsignedInt322 = (UnsignedInt32)enumeration.nextElement();
            FspLockRequest fspLockRequest = (FspLockRequest)this.mLockRecords.get(unsignedInt322);
            if (!unsignedInt32.equals((Object)fspLockRequest.getFspReqId())) continue;
            return fspLockRequest;
        }
        return null;
    }

    public void unlock(UnsignedInt32 unsignedInt32, HscResourceId hscResourceId) throws PIHscServerException {
        Vector<HscResourceId> vector = new Vector<HscResourceId>();
        vector.addElement(hscResourceId);
        this.unlock(unsignedInt32, vector);
    }

    public void unlock(UnsignedInt32 unsignedInt32, Vector vector) throws PIHscServerException {
        FspLockRequest fspLockRequest = (FspLockRequest)this.mLockRecords.get(unsignedInt32);
        if (fspLockRequest.unlock(vector)) {
            this.mLockRecords.remove(unsignedInt32);
        }
    }

    public void unlockAll() throws PIHscServerException {
        this.getCmdHelper().unlockAll();
    }

    public void forceUnlock(String string) throws PIHscServerException {
        this.getCmdHelper().disconnectHmc(string);
    }

    public FspLockRecord[] getHmcLockStatus(String string) throws PIHscServerException {
        return this.getCmdHelper().getHmcLockStatus(string);
    }

    public FspLockRecord[] getAllLockRecords() throws PIHscServerException {
        FspHmcInfoData fspHmcInfoData = this.getCmdHelper().getHmcInformation();
        FspHmcInformation[] fspHmcInformationArray = fspHmcInfoData.getFspHmcInfoList();
        Vector<FspLockRecord> vector = new Vector<FspLockRecord>();
        for (int i = 0; i < fspHmcInformationArray.length; ++i) {
            if (fspHmcInformationArray[i].getToolType().longValue() != 1213023008L) continue;
            System.out.println("HMC " + fspHmcInformationArray[i].getHmcId() + " conn status: " + fspHmcInformationArray[i].getHmcConnectionStatus());
            System.out.println("HMC " + fspHmcInformationArray[i].getHmcId() + " tool type: " + fspHmcInformationArray[i].getToolType());
            System.out.println("HMC " + fspHmcInformationArray[i].getHmcId() + " conn status: " + fspHmcInformationArray[i].getHmcConnectionStatus());
            FspLockRecord[] fspLockRecordArray = this.getHmcLockStatus(fspHmcInformationArray[i].getHmcId());
            if (fspLockRecordArray == null) continue;
            for (int j = 0; j < fspLockRecordArray.length; ++j) {
                vector.addElement(fspLockRecordArray[j]);
            }
        }
        FspLockRecord[] fspLockRecordArray = new FspLockRecord[vector.size()];
        return vector.toArray(fspLockRecordArray);
    }

    public void dumpAllFspLockRecords() throws PIHscServerException {
        FspHmcInfoData fspHmcInfoData = this.getCmdHelper().getHmcInformation();
        FspHmcInformation[] fspHmcInformationArray = fspHmcInfoData.getFspHmcInfoList();
        System.out.println("-------------------------------begin print all fsp locks-----------");
        for (int i = 0; i < fspHmcInformationArray.length; ++i) {
            if (fspHmcInformationArray[i].getToolType().longValue() != 1213023008L) continue;
            System.out.println("HMC " + fspHmcInformationArray[i].getHmcId() + " conn status: " + fspHmcInformationArray[i].getHmcConnectionStatus());
            System.out.println("HMC " + fspHmcInformationArray[i].getHmcId() + " tool type: " + fspHmcInformationArray[i].getToolType());
            System.out.println("HMC " + fspHmcInformationArray[i].getHmcId() + " conn status: " + fspHmcInformationArray[i].getHmcConnectionStatus());
            this.dumpLockRecords(fspHmcInformationArray[i].getHmcId());
        }
        System.out.println("-------------------------------begin print all fsp locks-----------");
        this.printLockTable();
    }

    public void dumpLockRecords(String string) throws PIHscServerException {
        FspLockRecord[] fspLockRecordArray = this.getHmcLockStatus(string);
        System.out.println("-------------------------------begin print lock records for " + string);
        for (int i = 0; i < fspLockRecordArray.length; ++i) {
            System.out.println("lock record[" + i + "] " + fspLockRecordArray[i]);
        }
        System.out.println("-------------------------------end print lock records for " + string);
    }

    public void printLockTable() {
        System.out.println("------------------start fsp lock table dump=====================");
        System.out.println("mLockRecords " + this.mLockRecords);
        System.out.println("------------------end start fsp lock table dump=====================");
    }
}

